#!/bin/bash
# Setup script for Trunks Dashboard
set -e

# Install system dependencies
sudo apt-get update
# Install Apache, PHP, and Composer. Install a database server only if one isn't present.
sudo apt-get install -y apache2 php php-mysql composer
if ! dpkg -l | grep -qE 'mariadb-server|mysql-server'; then
  sudo apt-get install -y mariadb-server
fi

# Install PHP dependencies
composer install

# Create MySQL database and user
MYSQL_ROOT_PASSWORD=${MYSQL_ROOT_PASSWORD:-root}
DB_USER=trunks_user
DB_PASS=trunks_pass
mysql -u root -p"$MYSQL_ROOT_PASSWORD" < setup.sql
mysql -u root -p"$MYSQL_ROOT_PASSWORD" -e "CREATE USER IF NOT EXISTS '$DB_USER'@'localhost' IDENTIFIED BY '$DB_PASS';"
mysql -u root -p"$MYSQL_ROOT_PASSWORD" -e "GRANT ALL PRIVILEGES ON trunks_dashboard.* TO '$DB_USER'@'localhost'; FLUSH PRIVILEGES;"

echo "Setup complete"
