<?php
require_once '../includes/auth.php';
require_once '../includes/db.php';
check_login();

// Optional role check: restrict to admin if role set
if (isset($_SESSION['role']) && $_SESSION['role'] !== 'admin') {
    echo 'Access denied.';
    exit();
}

// Handle resolving tickets
if (isset($_GET['resolve'])) {
    $ticketId = (int)$_GET['resolve'];
    $stmt = $pdo->prepare("UPDATE tickets SET status = 'closed' WHERE id = ?");
    $stmt->execute([$ticketId]);
    $status = isset($_GET['status']) && $_GET['status'] === 'closed' ? 'closed' : 'open';
    header('Location: tickets.php?status=' . $status);
    exit();
}

// Determine filter status
$status = isset($_GET['status']) && $_GET['status'] === 'closed' ? 'closed' : 'open';

// Fetch tickets based on status
$stmt = $pdo->prepare('SELECT t.*, u.username FROM tickets t JOIN users u ON t.user_id = u.id WHERE t.status = ? ORDER BY t.created_at DESC');
$stmt->execute([$status]);
$tickets = $stmt->fetchAll();

$viewTicket = null;
if (isset($_GET['view'])) {
    $viewId = (int)$_GET['view'];
    $viewStmt = $pdo->prepare('SELECT t.*, u.username FROM tickets t JOIN users u ON t.user_id = u.id WHERE t.id = ?');
    $viewStmt->execute([$viewId]);
    $viewTicket = $viewStmt->fetch();
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Tickets</title>
</head>
<body>
<h1>Tickets</h1>
<p>
    <a href="tickets.php?status=open">Open Tickets</a> |
    <a href="tickets.php?status=closed">Closed Tickets</a> |
    <a href="dashboard.php">Back to Dashboard</a>
</p>
<table border="1" cellpadding="5" cellspacing="0">
    <tr>
        <th>ID</th>
        <th>User</th>
        <th>Type</th>
        <th>Status</th>
        <th>Created At</th>
        <th>Actions</th>
    </tr>
    <?php foreach ($tickets as $t): ?>
        <tr>
            <td><?php echo $t['id']; ?></td>
            <td><?php echo htmlspecialchars($t['username']); ?></td>
            <td><?php echo htmlspecialchars($t['type']); ?></td>
            <td><?php echo htmlspecialchars($t['status']); ?></td>
            <td><?php echo htmlspecialchars($t['created_at']); ?></td>
            <td>
                <a href="tickets.php?view=<?php echo $t['id']; ?>&status=<?php echo $status; ?>">View</a>
                <?php if ($t['status'] === 'open'): ?>
                    | <a href="tickets.php?resolve=<?php echo $t['id']; ?>&status=<?php echo $status; ?>">Mark Resolved</a>
                <?php endif; ?>
            </td>
        </tr>
    <?php endforeach; ?>
</table>

<?php if ($viewTicket): ?>
    <h2>Ticket Details</h2>
    <p><strong>ID:</strong> <?php echo $viewTicket['id']; ?></p>
    <p><strong>User:</strong> <?php echo htmlspecialchars($viewTicket['username']); ?></p>
    <p><strong>Type:</strong> <?php echo htmlspecialchars($viewTicket['type']); ?></p>
    <p><strong>Status:</strong> <?php echo htmlspecialchars($viewTicket['status']); ?></p>
    <p><strong>Details:</strong><br><?php echo nl2br(htmlspecialchars($viewTicket['details'])); ?></p>
    <p><strong>Created At:</strong> <?php echo htmlspecialchars($viewTicket['created_at']); ?></p>
<?php endif; ?>

</body>
</html>
