<?php
require_once '../includes/auth.php';
require_once '../includes/db.php';
check_login();

if (!isset($_GET['number'])) {
    header('Location: dashboard.php');
    exit();
}

$number = $_GET['number'];
$stmt = $pdo->prepare('SELECT pn.*, u.username AS assigned_user, t.name AS trunk_name, p.name AS provider_name FROM phone_numbers pn LEFT JOIN users u ON pn.assigned_to = u.id LEFT JOIN trunks t ON pn.trunk_id = t.id LEFT JOIN providers p ON t.provider_id = p.id WHERE pn.number = ?');
$stmt->execute([$number]);
$pn = $stmt->fetch();

$title = 'Number Details';
include 'header.php';

if ($pn) {
    $historyStmt = $pdo->prepare('SELECT h.*, u.username FROM phone_number_history h JOIN users u ON h.user_id = u.id WHERE h.phone_number_id = ? ORDER BY h.changed_at DESC');
    $historyStmt->execute([$pn['id']]);
    $history = $historyStmt->fetchAll();
    $extStmt = $pdo->prepare('SELECT extension FROM extensions WHERE phone_number_id = ?');
    $extStmt->execute([$pn['id']]);
    $extensions = $extStmt->fetchAll(PDO::FETCH_COLUMN);
    ?>
    <h1 class="h4 mb-3">Number Details for <?php echo htmlspecialchars($pn['number']); ?></h1>
    <table class="table table-dark table-striped table-bordered">
        <tbody>
            <tr><th>Status</th><td><?php echo htmlspecialchars($pn['status']); ?></td></tr>
            <tr><th>Assigned To</th><td><?php echo htmlspecialchars($pn['assigned_user']); ?></td></tr>
            <tr><th>Tracking #</th><td><?php echo htmlspecialchars($pn['tracking_number']); ?></td></tr>
            <tr><th>Maintenance Window</th><td><?php echo htmlspecialchars($pn['maintenance_window']); ?></td></tr>
            <tr><th>Trunk</th><td><?php echo htmlspecialchars($pn['trunk_name']); ?></td></tr>
            <tr><th>Provider</th><td><?php echo htmlspecialchars($pn['provider_name']); ?></td></tr>
            <tr><th>Type</th><td><?php echo htmlspecialchars($pn['type']); ?></td></tr>
            <tr><th>Call Recording</th><td><?php echo $pn['call_recording_enabled'] ? 'Enabled' : 'Disabled'; ?></td></tr>
            <tr><th>Extensions</th><td><?php echo htmlspecialchars(implode(', ', $extensions)); ?></td></tr>
        </tbody>
    </table>
    <h2 class="h5 mt-4">History</h2>
    <ul class="list-group list-group-flush">
        <?php foreach ($history as $h): ?>
            <li class="list-group-item bg-dark text-light border-secondary">
                <strong><?php echo htmlspecialchars($h['changed_at']); ?></strong> -
                <?php echo htmlspecialchars($h['username']); ?> -
                <?php echo htmlspecialchars($h['change_description']); ?>
            </li>
        <?php endforeach; ?>
    </ul>
    <a href="dashboard.php" class="btn btn-link mt-3">Back to Dashboard</a>
    <?php
} else {
    ?>
    <div class="alert alert-warning">Number not found.</div>
    <a href="dashboard.php" class="btn btn-link">Back to Dashboard</a>
    <?php
}

include 'footer.php';