<?php
require_once '../includes/auth.php';
require_once '../includes/db.php';
check_login();

$submitted = false;
$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verify_csrf_token($_POST['csrf_token'] ?? '')) {
        $error = 'Invalid CSRF token';
    } else {
        $allowed = ['extension_request','personal_number_request','voicemail_update'];
        $type = $_POST['type'] ?? '';
        if (!in_array($type, $allowed, true)) {
            $error = 'Invalid request type';
        } else {
            $details = strip_tags($_POST['details'] ?? '');
            $stmt = $pdo->prepare('INSERT INTO tickets (user_id, type, details) VALUES (?,?,?)');
            $stmt->execute([current_user_id(), $type, $details]);
            $submitted = true;
        }
    }
}

$title = 'Submit Request';
include 'header.php';
?>
<h1 class="h4 mb-3">Submit Request</h1>
<?php if ($submitted): ?>
    <div class="alert alert-success">Request submitted.</div>
<?php elseif ($error): ?>
    <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
<?php endif; ?>
<form method="POST">
    <div class="mb-3">
        <label class="form-label">Type</label>
        <select name="type" class="form-select">
            <option value="extension_request">Phone Extension</option>
            <option value="personal_number_request">Personal Inbound Number</option>
            <option value="voicemail_update">Update Voicemail Password</option>
        </select>
    </div>
    <div class="mb-3">
        <label class="form-label">Details</label>
        <textarea name="details" class="form-control" rows="4"></textarea>
    </div>
    <input type="hidden" name="csrf_token" value="<?php echo csrf_token(); ?>">
    <button type="submit" class="btn btn-primary">Submit</button>
</form>
<?php include 'footer.php'; ?>