<?php
require_once '../includes/auth.php';
require_once '../includes/db.php';
check_login();

if (isset($_GET['delete'])) {
    $stmt = $pdo->prepare('DELETE FROM providers WHERE id = ?');
    $stmt->execute([$_GET['delete']]);
    header('Location: providers.php');
    exit();
}

$providers = $pdo->query('SELECT * FROM providers')->fetchAll();

$title = 'Providers';
include 'header.php';
?>
<h1 class="h3 mb-4">Providers</h1>
<a href="edit_provider.php" class="btn btn-primary mb-3">Add Provider</a>
<table class="table table-dark table-striped table-bordered">
    <thead>
        <tr>
            <th>Name</th>
            <th>Contact Email</th>
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
    <?php foreach ($providers as $provider): ?>
        <tr>
            <td><?php echo htmlspecialchars($provider['name']); ?></td>
            <td><?php echo htmlspecialchars($provider['contact_email']); ?></td>
            <td>
                <a href="edit_provider.php?id=<?php echo $provider['id']; ?>" class="btn btn-sm btn-secondary">Edit</a>
                <a href="providers.php?delete=<?php echo $provider['id']; ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete provider?');">Delete</a>
            </td>
        </tr>
    <?php endforeach; ?>
    </tbody>
</table>
<a href="dashboard.php" class="btn btn-link">Back to Dashboard</a>
<?php include 'footer.php'; ?>
