<?php
require_once '../includes/db.php';
require_once '../includes/auth.php';
require_once '../vendor/autoload.php';
use Twilio\Rest\Client;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verify_csrf_token($_POST['csrf_token'] ?? '')) {
        header('Location: index.php?error=' . urlencode('Invalid CSRF token'));
        exit();
    }
    $email = $_POST['email'];
    $stmt = $pdo->prepare('SELECT id, phone FROM users WHERE email = ?');
    $stmt->execute([$email]);
    $user = $stmt->fetch();
    if ($user) {
        $token = bin2hex(random_bytes(16));
        $expires = date('Y-m-d H:i:s', time()+3600);
        $pdo->prepare('INSERT INTO login_tokens (user_id, token, expires_at) VALUES (?,?,?)')
            ->execute([$user['id'], $token, $expires]);
        $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
        $baseUrl = $scheme . '://' . $_SERVER['HTTP_HOST'];
        $loginLink = $baseUrl . "/verify_login.php?token=$token";
        $accountSid = getenv('TWILIO_ACCOUNT_SID');
        $authToken  = getenv('TWILIO_AUTH_TOKEN');
        $fromNumber = getenv('TWILIO_FROM_NUMBER');
        if ($accountSid && $authToken && $fromNumber && $user['phone']) {
            $client = new Client($accountSid, $authToken);
            $client->messages->create($user['phone'], [
                'from' => $fromNumber,
                'body' => "Login link: $loginLink"
            ]);
        } else {
            mail($email, 'Login Link', "Use this link to login: $loginLink");
        }
        header('Location: index.php?message=' . urlencode('Login link sent.'));
        exit();
    } else {
        header('Location: index.php?error=' . urlencode('Email not found'));
        exit();
    }
} else {
    header('Location: index.php');
    exit();
}
?>