<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';

$title = 'Sign in';
$noNav = true;
$fullWidth = true;
$brand = $brand ?? 'Tool Portal';

$error = null;
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!verify_csrf_token($_POST['csrf_token'] ?? '')) {
        $error = 'Invalid session token. Please refresh and try again.';
    } else {
        $username = trim($_POST['username'] ?? '');
        $password = $_POST['password'] ?? '';
        if ($username === '' || $password === '') {
            $error = 'Username and password are required.';
        } else {
            try {
                $stmt = $pdo->prepare('SELECT id, password_hash FROM users WHERE username = ? LIMIT 1');
                $stmt->execute([$username]);
                $row = $stmt->fetch();
                if ($row && password_verify($password, $row['password_hash'])) {
                    $_SESSION['user_id'] = $row['id'];
                    header('Location: dashboard.php'); exit;
                } else {
                    $error = 'Invalid credentials.';
                }
            } catch (Throwable $e) {
                $error = 'Login error: ' . $e->getMessage();
            }
        }
    }
}

include __DIR__ . '/header.php';
?>
<div class="auth-wrap">
  <section class="auth-visual d-none d-lg-block">
    <div class="copy">
      <div>
        <div class="mb-3">
          <span class="brand-dot"></span>
        </div>
        <h1>Welcome to <strong><?php echo htmlspecialchars($brand); ?></strong></h1>
        <p>Your unified, secure dashboard for trunks, providers, and requests.</p>
      </div>
    </div>
    <span class="glow"></span>
  </section>
  <section class="d-flex align-items-center justify-content-center p-4 p-lg-5">
    <div class="card card-neo shadow-lg" style="max-width: 420px; width: 100%;">
      <div class="card-body p-4 p-lg-5">
        <?php if ($error): ?>
          <div class="alert alert-danger mb-4"><?php echo htmlspecialchars($error); ?></div>
        <?php elseif (isset($_GET['message'])): ?>
          <div class="alert alert-success mb-4"><?php echo htmlspecialchars($_GET['message']); ?></div>
        <?php endif; ?>
        <h2 class="mb-1">Sign in</h2>
        <p class="text-muted mb-4">Use your account credentials</p>
        <form method="POST" action="login.php" class="mb-3" autocomplete="off" novalidate>
          <div class="mb-3">
            <label class="form-label">Username</label>
            <input type="text" class="form-control" name="username" autocomplete="username" required>
          </div>
          <div class="mb-3">
            <label class="form-label d-flex justify-content-between">
              <span>Password</span>
              <a class="link-muted small" href="#" onclick="alert('Ask IT to reset your password.');return false;">Forgot?</a>
            </label>
            <input type="password" class="form-control" name="password" autocomplete="current-password" required>
          </div>
          <input type="hidden" name="csrf_token" value="<?php echo csrf_token(); ?>">
          <button type="submit" class="btn btn-primary w-100">Sign in</button>
        </form>
      </div>
    </div>
  </section>
</div>
<?php include __DIR__ . '/footer.php'; ?>
