<?php
if (!isset($title)) { $title = 'Tool Portal'; }
$brand = $brand ?? 'Tool Portal';
$noNav = $noNav ?? false;
$fullWidth = $fullWidth ?? false;
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?php echo htmlspecialchars($title); ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" crossorigin="anonymous">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
  <!-- because header.php is inside /public, go up one dir to /css/app.css -->
  <link href="../css/app.css" rel="stylesheet">
</head>
<body data-bs-theme="dark">
<?php if (!$noNav): ?>
<nav class="navbar navbar-expand-lg sticky-top">
  <div class="container-xxl">
    <a class="navbar-brand" href="dashboard.php">
      <span class="brand-dot"></span>
      <?php echo htmlspecialchars($brand); ?>
    </a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarMain" aria-controls="navbarMain" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarMain">
      <ul class="navbar-nav ms-auto align-items-lg-center gap-lg-2">
        <li class="nav-item"><a class="nav-link" href="dashboard.php"><i class="bi bi-grid-1x2-fill me-1"></i>Dashboard</a></li>
        <li class="nav-item"><a class="nav-link" href="providers.php"><i class="bi bi-hdd-network me-1"></i>Providers</a></li>
        <li class="nav-item"><a class="nav-link" href="request.php"><i class="bi bi-inboxes-fill me-1"></i>Requests</a></li>
        <li class="nav-item"><a class="nav-link" href="logout.php"><i class="bi bi-box-arrow-right me-1"></i>Logout</a></li>
      </ul>
    </div>
  </div>
</nav>
<?php endif; ?>

<?php if (!$fullWidth): ?>
<main class="container-xxl py-4">
<?php endif; ?>
