<?php
require_once '../includes/auth.php';
require_once '../includes/db.php';
check_login();

$id = $_GET['id'] ?? null;
$name = '';
$contact_email = '';

if ($id) {
    $stmt = $pdo->prepare('SELECT * FROM providers WHERE id = ?');
    $stmt->execute([$id]);
    $provider = $stmt->fetch();
    if ($provider) {
        $name = $provider['name'];
        $contact_email = $provider['contact_email'];
    }
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'];
    $contact_email = $_POST['contact_email'];
    if ($id) {
        $stmt = $pdo->prepare('UPDATE providers SET name = ?, contact_email = ? WHERE id = ?');
        $stmt->execute([$name, $contact_email, $id]);
    } else {
        $stmt = $pdo->prepare('INSERT INTO providers (name, contact_email) VALUES (?, ?)');
        $stmt->execute([$name, $contact_email]);
    }
    header('Location: providers.php');
    exit();
}
$title = $id ? 'Edit Provider' : 'Add Provider';
include 'header.php';
?>
<h1 class="h3 mb-4"><?php echo $title; ?></h1>
<form method="POST" class="mb-3">
    <div class="mb-3">
        <label class="form-label">Name
            <input type="text" name="name" value="<?php echo htmlspecialchars($name); ?>" class="form-control" required>
        </label>
    </div>
    <div class="mb-3">
        <label class="form-label">Contact Email
            <input type="email" name="contact_email" value="<?php echo htmlspecialchars($contact_email); ?>" class="form-control">
        </label>
    </div>
    <button type="submit" class="btn btn-primary">Save</button>
    <a href="providers.php" class="btn btn-secondary">Cancel</a>
</form>
<?php include 'footer.php'; ?>
