<?php
require_once '../includes/auth.php';
require_once '../includes/db.php';
check_login();

if (!isset($_GET['id'])) {
    header('Location: dashboard.php');
    exit();
}

$id = $_GET['id'];
$stmt = $pdo->prepare('SELECT * FROM phone_numbers WHERE id = ?');
$stmt->execute([$id]);
$pn = $stmt->fetch();

if (!$pn) {
    echo 'Phone number not found.';
    exit();
}

$users = $pdo->query('SELECT id, username FROM users ORDER BY username')->fetchAll();
$trunks = $pdo->query('SELECT id, name FROM trunks ORDER BY name')->fetchAll();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $status = $_POST['status'];
    $assigned_to = $_POST['assigned_to'] !== '' ? $_POST['assigned_to'] : null;
    $tracking_number = $_POST['tracking_number'];
    $maintenance_window = $_POST['maintenance_window'];
    $trunk_id = $_POST['trunk_id'] !== '' ? $_POST['trunk_id'] : null;
    $type = $_POST['type'];
    $call_recording_enabled = isset($_POST['call_recording_enabled']) ? 1 : 0;

    $old = $pn;

$new_number = $_POST['number'];

$update = $pdo->prepare('UPDATE phone_numbers SET number=?, status=?, assigned_to=?, tracking_number=?, maintenance_window=?, trunk_id=?, type=?, call_recording_enabled=? WHERE id=?');
$update->execute([$new_number, $status, $assigned_to, $tracking_number, $maintenance_window, $trunk_id, $type, $call_recording_enabled, $id]);

    // Build change description
    $changes = [];
    if ($old['number'] !== $new_number) {
        $changes[] = "number from '{$old['number']}' to '$new_number'";
    }
    if ($old['status'] !== $status) {
        $changes[] = "status from '{$old['status']}' to '$status'";
    }
    if ($old['assigned_to'] != $assigned_to) {
        $changes[] = "assigned_to from '{$old['assigned_to']}' to '$assigned_to'";
    }
    if ($old['tracking_number'] !== $tracking_number) {
        $changes[] = "tracking_number from '{$old['tracking_number']}' to '$tracking_number'";
    }
    if ($old['maintenance_window'] !== $maintenance_window) {
        $changes[] = "maintenance_window from '{$old['maintenance_window']}' to '$maintenance_window'";
    }
    if ($old['trunk_id'] != $trunk_id) {
        $changes[] = "trunk_id from '{$old['trunk_id']}' to '$trunk_id'";
    }
    if ($old['type'] !== $type) {
        $changes[] = "type from '{$old['type']}' to '$type'";
    }
    if ($old['call_recording_enabled'] != $call_recording_enabled) {
        $changes[] = "call_recording_enabled from '{$old['call_recording_enabled']}' to '$call_recording_enabled'";
    }

    $desc = $changes ? implode('; ', $changes) : 'No changes';

    $hist = $pdo->prepare('INSERT INTO phone_number_history (phone_number_id, user_id, change_description) VALUES (?, ?, ?)');
    $hist->execute([$id, current_user_id(), $desc]);

    header('Location: search.php?number=' . urlencode($new_number));
    exit();
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Edit Phone Number</title>
</head>
<body>
<h1>Edit Phone Number <?php echo htmlspecialchars($pn['number']); ?></h1>
<form method="POST">
    <label>Number: <input type="text" name="number" value="<?php echo htmlspecialchars($pn['number']); ?>"></label><br>
    <label>Status: <input type="text" name="status" value="<?php echo htmlspecialchars($pn['status']); ?>"></label><br>
    <label>Assigned To:
        <select name="assigned_to">
            <option value="">-- None --</option>
            <?php foreach ($users as $user): ?>
                <option value="<?php echo $user['id']; ?>" <?php if ($user['id'] == $pn['assigned_to']) echo 'selected'; ?>><?php echo htmlspecialchars($user['username']); ?></option>
            <?php endforeach; ?>
        </select>
    </label><br>
    <label>Tracking #: <input type="text" name="tracking_number" value="<?php echo htmlspecialchars($pn['tracking_number']); ?>"></label><br>
    <label>Maintenance Window: <input type="text" name="maintenance_window" value="<?php echo htmlspecialchars($pn['maintenance_window']); ?>"></label><br>
    <label>Trunk:
        <select name="trunk_id">
            <option value="">-- None --</option>
            <?php foreach ($trunks as $trunk): ?>
                <option value="<?php echo $trunk['id']; ?>" <?php if ($trunk['id'] == $pn['trunk_id']) echo 'selected'; ?>><?php echo htmlspecialchars($trunk['name']); ?></option>
            <?php endforeach; ?>
        </select>
    </label><br>
    <label>Type:
        <select name="type">
            <option value="personal" <?php if ($pn['type'] == 'personal') echo 'selected'; ?>>Personal</option>
            <option value="ivr" <?php if ($pn['type'] == 'ivr') echo 'selected'; ?>>IVR</option>
        </select>
    </label><br>
    <label><input type="checkbox" name="call_recording_enabled" value="1" <?php if ($pn['call_recording_enabled']) echo 'checked'; ?>> Call Recording Enabled</label><br>
    <button type="submit">Save</button>
</form>
<a href="search.php?number=<?php echo urlencode($pn['number']); ?>">Cancel</a>
</body>
</html>
