<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';
check_login();

function safeCount($pdo, $sql){
  try { return (int)$pdo->query($sql)->fetchColumn(); }
  catch (Throwable $e) { return 0; }
}

$totalNumbers   = safeCount($pdo, 'SELECT COUNT(*) FROM phone_numbers');
$totalTrunks    = safeCount($pdo, 'SELECT COUNT(*) FROM trunks');
$assignedNumbers= safeCount($pdo, 'SELECT COUNT(*) FROM phone_numbers WHERE assigned_to IS NOT NULL');
$totalProviders = safeCount($pdo, 'SELECT COUNT(*) FROM providers');

try {
  $trunks = $pdo->query('
    SELECT t.name, p.name AS provider_name
    FROM trunks t
    JOIN providers p ON t.provider_id = p.id
    ORDER BY t.name
  ')->fetchAll();
} catch (Throwable $e) { $trunks = []; }

$title = 'Dashboard';
$brand = $brand ?? 'Tool Portal';
include __DIR__ . '/header.php';
?>
<div class="d-flex align-items-center justify-content-between mb-3">
  <h1 class="h3 mb-0">Dashboard</h1>
  <div class="text-muted">Last updated: <?php echo date('M j, Y g:i A'); ?></div>
</div>

<div class="row g-4 mb-5">
  <div class="col-12 col-sm-6 col-xl-3">
    <div class="card card-neo h-100">
      <div class="card-body d-flex align-items-center gap-3">
        <span class="stat-icon"><i class="bi bi-telephone-fill fs-4"></i></span>
        <div>
          <div class="text-muted small">Total Numbers</div>
          <div class="kpi"><?php echo (int)$totalNumbers; ?></div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-12 col-sm-6 col-xl-3">
    <div class="card card-neo h-100">
      <div class="card-body d-flex align-items-center gap-3">
        <span class="stat-icon"><i class="bi bi-diagram-3-fill fs-4"></i></span>
        <div>
          <div class="text-muted small">Total Trunks</div>
          <div class="kpi"><?php echo (int)$totalTrunks; ?></div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-12 col-sm-6 col-xl-3">
    <div class="card card-neo h-100">
      <div class="card-body d-flex align-items-center gap-3">
        <span class="stat-icon" style="background:rgba(245,158,11,.12);border-color:rgba(245,158,11,.35)"><i class="bi bi-person-check-fill fs-4"></i></span>
        <div>
          <div class="text-muted small">Assigned Numbers</div>
          <div class="kpi"><?php echo (int)$assignedNumbers; ?></div>
        </div>
      </div>
    </div>
  </div>
  <div class="col-12 col-sm-6 col-xl-3">
    <div class="card card-neo h-100">
      <div class="card-body d-flex align-items-center gap-3">
        <span class="stat-icon" style="background:rgba(99,102,241,.12);border-color:rgba(99,102,241,.35)"><i class="bi bi-hdd-network fs-4"></i></span>
        <div>
          <div class="text-muted small">Providers</div>
          <div class="kpi"><?php echo (int)$totalProviders; ?></div>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="card card-neo">
  <div class="card-body">
    <div class="d-flex align-items-center justify-content-between mb-3">
      <h2 class="h5 mb-0">Trunks</h2>
      <a href="providers.php" class="btn btn-sm btn-outline-light"><i class="bi bi-plus-lg me-1"></i>New</a>
    </div>
    <?php if (!$trunks): ?>
      <div class="text-muted">No trunks found.</div>
    <?php else: ?>
    <div class="table-responsive">
      <table class="table table-hover align-middle">
        <thead><tr><th>Name</th><th>Provider</th></tr></thead>
        <tbody>
          <?php foreach ($trunks as $t): ?>
            <tr>
              <td><?php echo htmlspecialchars($t['name']); ?></td>
              <td><span class="badge rounded-pill"><?php echo htmlspecialchars($t['provider_name']); ?></span></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
    <?php endif; ?>
  </div>
</div>

<?php include __DIR__ . '/footer.php'; ?>
